# File: bookstore.sql
# A sample database of books

# Create a fresh book database and table.

CREATE DATABASE IF NOT EXISTS bookstore;
USE bookstore;

CREATE TABLE books 
(
  isbn   CHAR(15)       PRIMARY KEY NOT NULL,
  title  VARCHAR(100)   NOT NULL,
  author VARCHAR(100)    NOT NULL,
  pub    VARCHAR(20)    NOT NULL,
  year   year           NOT NULL,
  price  DECIMAL(9,2)   DEFAULT NULL
);


INSERT INTO books VALUES (
   '0-672-31784-2',
   'PHP and MySQL Web Development',
   'Luke Welling, Laura Thomson',
   'Sams', 2001, 74.95
);

INSERT INTO books VALUES (
   '0-13-066190-2', 
   'Core MySQL', 
   'Leon Atkinson',
   'Prentice Hall PTR', 2001, 68.00
);

INSERT INTO books VALUES (
   '1-861003-02-1',
   'Professional Apache',
   'Peter Wainwright',
   'Wrox Press Ltd', 1999, 74.95
);

INSERT INTO books VALUES (
   '0-13-089793-0',
   'Core WEB Programming, 2nd Ed',
   'Marty Hall, Larry Brown',
   'Prentice Hall PTR', 2001, 75.00
);

INSERT INTO books VALUES (
   '0-672-31880-6',
   'CGI in 24 Hours',
   'Rafe Colburn',
   'Sams', 2000, 37.95
);

INSERT INTO books VALUES (
   '1-861003-14-5',
   'Beginning Perl',
   'Simon Cozens',
   'Wrox Press Ltd', 2000, 59.95
);

INSERT INTO books VALUES (
   '0-596-00027-8',
   'Programming Perl, 3rd Ed',
   'Larry Wall, Tom Christianson, Jon Orwant',
   'O\'Reilly', 2000, 72.95
);

INSERT INTO books VALUES (
   '1-56592-243-3',
   'Perl Cookbook',
   'Tom Christianson, Nathan Torkington',
   'O\'Reilly', 1999, 56.95
);
