<?php
require_once("auth.php");
require_once("db_connect.php");

// -----------------------------------------------------------------------------
// Insert a book from the book database
// -----------------------------------------------------------------------------

// If the "Insert" button was clicked check that an ISBN was entered.
// Otherwise display the insert form so that the book data can be entered

if (isset($_REQUEST['insert'])) // submit button was clicked
{
   if ($_REQUEST['isbn'] == '')
   {
      display_form_page("ERROR: Please enter an ISBN");
   }
   else
   {
      $success = insert_book();
      if ($success)
      {
         $message = "New book was inserted.";
      }
      else
      {
         $message = "Duplicate ISBN: Database unchanged.";
      }
      display_response_page($message);
   }
}
else
{
   display_form_page("");
}
?>

<?php

// -----------------------------------------------------------------------------
// Display page in response to a book insertion
// $message is a status messeage that the book was inserted or an error message
// -----------------------------------------------------------------------------

   function display_response_page($message)
   {
?>
   <html>
   <head><title>Insert new book</title></head>
   <body>
   <h1>Insert new book</h1>
   <h2><?php echo $message?></h1>
   <?include("links.html");?>
   </body>
   </html>
<?php
}
?>

<?php

// -----------------------------------------------------------------------------
// Display rhe page showing the delete form.
// $message is a message such as an error message that is displayed
// -----------------------------------------------------------------------------

function display_form_page($message)
{
?>
<html>
<head><title>Insert new book</title></head>
<body>
<h1>Insert new book</h1>

<h2><?php print $message?></h2>

<form method = "POST">
<table border="1">
<tr><td>
<table border="0">
   <tr>
      <td>ISBN:</td>
      <td><input type = "text" name = "isbn"></td>
   </tr>
   <tr>
      <td>Title:</td>
      <td><input type = "text" name = "title" size="50"></td>
   </tr>
   <tr>
      <td>Author:</td>
      <td><input type = "text" name = "author" size="50"></td>
   </tr>
   <tr>
      <td>Publisher:</td>
      <td><input type = "text" name = "publisher"></td>
   </tr>
   <tr>
      <td>Year:</td>
      <td><input type = "text" name = "year"></td>
   </tr>
   <tr>
      <td>Price:</td>
      <td><input type = "text" name = "price"></td>
   </tr>

   <tr><td>&nbsp;</td>
      <td align="right"><input type = "submit" name = "insert" value = "Insert Book"></td>
   </tr>
</table>
</td></tr>
</table>
</form>
<?include("links.html");?>
</body>
</html>
<?php
}
?>

<?php

// -----------------------------------------------------------------------------
// Insert a new book into the database using the INSERT query.
// Return true if the book was successfully inserted.
// Otherewise false is returned to indicate that a duplicate ISBN was specified.
// -----------------------------------------------------------------------------

function insert_book()
{
   $database = "bookstore";
   $table = "books";
   $db_link = db_connect($database);

   $isbn = addslashes($_REQUEST['isbn']);
   $title = addslashes($_REQUEST['title']);
   $author = addslashes($_REQUEST['author']);
   $publisher = addslashes($_REQUEST['publisher']);
   $year = addslashes($_REQUEST['year']);
   $price = addslashes($_REQUEST['price']);

   $query = "INSERT INTO $table VALUES "
          . "('$isbn','$title','$author','$publisher','$year','$price')";
   $success = mysql_query($query);

   mysql_close($db_link);
   return $success;
}
?>
