<?php
require_once("auth.php");
require_once("db_connect.php");

// -----------------------------------------------------------------------------
// Update a book in the book database
// -----------------------------------------------------------------------------

// If the "Find Book" button was clicked check that an ISBN was entered.
// If the "Update" button was clicked make the updates.
// Otherwise display a form to specify the ISBN of the book to be updated.

if (isset($_REQUEST['find'])) // Find Book button was clicked
{
   if ($_REQUEST['isbn'] == '')
   {
      display_find_form_page("ERROR: Please enter an ISBN");
   }
   else
   {
      $row = find_book();
      if ($row)
      {
         display_update_page($row);
      }
      else
      {
         display_find_form_page("No book found with this ISBN.");
      }
   }
}
elseif (isset($_REQUEST['update'])) 
{
   update_book();
   display_find_form_page("Book data has been updated.");
}
else
{
   display_find_form_page("");
}
?>


<?php

// -----------------------------------------------------------------------------
// Display rhe page showing the find book form to specify the ISBN
// $message is a message such as an error message that is displayed
// -----------------------------------------------------------------------------


function display_find_form_page($message)
{
?>
<head><title>Find Book</title></head>
<body>
<h1>Find Book</h1>
<h2><?php echo $message?></h2>
<form method = "POST">
<table border="1">
<tr><td>
<table border="0">
   <tr>
      <td>ISBN:</td>
      <td><input type = "text" name = "isbn"></td>
   </tr>

   <tr><td>&nbsp;</td>
      <td align="right"><input type = "submit" name = "find" value = "Find Book"></td>
   </tr>
</table>
</td></tr>
</table>
</form>
<?include("links.html");?>
</body>
</html>
<?php
}
?>

<?php

// -----------------------------------------------------------------------------
// Display the page that gives the fields to update. This is similar to the
// insert book form escept the ISBN is not one of the fields. The ISBN is
// needed however so it is stored as a hidden field.
// $row contains the current data in the row to be updated.
// -----------------------------------------------------------------------------

function display_update_page($row)
{
   $isbn = htmlspecialchars(stripslashes($row['isbn']));
   $title = htmlspecialchars(stripslashes($row['title']));
   $author = htmlspecialchars(stripslashes($row['author']));
   $publisher = htmlspecialchars(stripslashes($row['pub']));
   $year = htmlspecialchars(stripslashes($row['year']));
   $price = htmlspecialchars(stripslashes($row['price']));
?>
<html>
<head><title>Update book information</title></head>
<body>
<h1>Update book information for ISBN <?php echo $isbn?></h1>

<form method = "POST">
<table border="1">
<tr><td>
<table border="0">
   <tr>
      <td>Title:</td>
      <td><input type = "text" name = "title" value="<?php echo $title?>" size="50"></td>
   </tr>
   <tr>
      <td>Author:</td>
      <td><input type = "text" name = "author" value="<?php echo $author?>" size="50"></td>
   </tr>
   <tr>
      <td>Publisher:</td>
      <td><input type = "text" name = "publisher" value="<?php echo $publisher?>"></td>
   </tr>
   <tr>
      <td>Year:</td>
      <td><input type = "text" name = "year" value="<?php echo $year?>"></td>
   </tr>
   <tr>
      <td>Price:</td>
      <td><input type = "text" name = "price" value="<?php echo $price?>"></td>
   </tr>

   <tr><td>&nbsp;</td>
      <td align="right"><input type = "submit" name = "update" value = "Update Book"></td>
   </tr>
</table>
</td></tr>
</table>
   <input type = "hidden" name = "isbn" value = "<?php echo $isbn?>"> 
</form>
<?include("links.html");?>
</body>
</html>
<?php
}
?>

<?php

// -----------------------------------------------------------------------------
// Make a SELECT query to find the book with a specified ISBN.
// Return the row of the table if the book is found.
// Otherwise return false to indicate that the book as not found. 
// -----------------------------------------------------------------------------

function find_book()
{
   $database = "bookstore";
   $table = "books";
   $db_link = db_connect($database);

   $isbn = addslashes($_REQUEST['isbn']);

   $query = "SELECT * FROM $table WHERE isbn = '$isbn'";
   $result = mysql_query($query);
   $row = mysql_fetch_assoc($result);
   mysql_free_result($result);
   return $row;
}
?>

<?php

// -----------------------------------------------------------------------------
// Make an UPDATE query to make the update given in the update form.
// -----------------------------------------------------------------------------

function update_book()
{
   $isbn = addslashes($_REQUEST['isbn']);
   $title = addslashes($_REQUEST['title']);
   $author = addslashes($_REQUEST['author']);
   $publisher = addslashes($_REQUEST['publisher']);
   $year = addslashes($_REQUEST['year']);
   $price = addslashes($_REQUEST['price']);

   $database = "bookstore";
   $table = "books";
   $db_link = db_connect($database);

   $query = "UPDATE $table SET title='$title', author='$author', "
          . "pub = '$publisher', year = '$year', price = '$price'"
          . "WHERE isbn = '$isbn'";

   mysql_query($query) or die("Update failed");
}
?>
