# File: bookstore.sql
# A sample database of books for an online bookstore

# Create a fresh book database

DROP DATABASE bookstore;
CREATE DATABASE IF NOT EXISTS bookstore;
USE bookstore;

# The books table holds all the information on the books in the bookstore

CREATE TABLE books 
(
  isbn   CHAR(15)       PRIMARY KEY NOT NULL,
  title  VARCHAR(100)   NOT NULL,
  author VARCHAR(100)   NOT NULL,
  pub    VARCHAR(20)    NOT NULL,
  year   year           NOT NULL,
  price  DECIMAL(9,2)   DEFAULT NULL
);

# Create a shopping cart table. This table will hold all the books in the
# carts of the current shoppers. The session_id uniquely identifies each customer.
# When a customer adds a new item to the cart a new row is inserted in this table.

CREATE TABLE cart
(
   session_id CHAR(32)  NOT NULL,
   isbn       CHAR(15)  NOT NULL,
   quantity   INT
);

# Create a customers table. Each row contains the information on each customer
# indexed by a unique customer_id.
# The customer_id field will match the customer_id field in the books_ordered table.

# For personal customer information we have only included the name fields.
# Many other fields would be needed for address and credit card information.

CREATE TABLE customers
(
   customer_id   CHAR(32) PRIMARY KEY,
   first_name    VARCHAR(50) NOT NULL,
   last_name     VARCHAR(50) NOT NULL
);

# Create a books_ordered table. Each row in this table is associated with some
# customer in the customers table as given by the customer_id field. 
# This field will match the customer_id field in the customers table.

# Using the customers and books_ordered tables we can extract all the information
# needed to make an order at checkout time.

# When q customer checks out the appropriate records are transfered from the cart table
# to the books_ordered table which has a similar structure as the cart table but
# using a generated customer_id field. We cannot use the session id here because a
# customer make make multiple orders per session.

CREATE TABLE books_ordered
(
   customer_id CHAR(32) NOT NULL,
   isbn        CHAR(15) NOT NULL,
   quantity    INT
);

# ----------------------------------------------------------------------------------------
# Insert a few books for testing

INSERT INTO books VALUES (
   '0-672-31784-2',
   'PHP and MySQL Web Development',
   'Luke Welling, Laura Thomson',
   'Sams', 2001, 74.95
);

INSERT INTO books VALUES (
   '0-13-066190-2', 
   'Core MySQL', 
   'Leon Atkinson',
   'Prentice Hall PTR', 2001, 68.00
);

INSERT INTO books VALUES (
   '1-861003-02-1',
   'Professional Apache',
   'Peter Wainwright',
   'Wrox Press Ltd', 1999, 74.95
);

INSERT INTO books VALUES (
   '0-13-089793-0',
   'Core WEB Programming, 2nd Ed',
   'Marty Hall, Larry Brown',
   'Prentice Hall PTR', 2001, 75.00
);

INSERT INTO books VALUES (
   '0-672-31880-6',
   'CGI in 24 Hours',
   'Rafe Colburn',
   'Sams', 2000, 37.95
);

INSERT INTO books VALUES (
   '1-861003-14-5',
   'Beginning Perl',
   'Simon Cozens',
   'Wrox Press Ltd', 2000, 59.95
);

INSERT INTO books VALUES (
   '0-596-00027-8',
   'Programming Perl, 3rd Ed',
   'Larry Wall, Tom Christianson, Jon Orwant',
   'O\'Reilly', 2000, 72.95
);

INSERT INTO books VALUES (
   '1-56592-243-3',
   'Perl Cookbook',
   'Tom Christianson, Nathan Torkington',
   'O\'Reilly', 1999, 56.95
);
