<?php
require_once("db_connect.php");
// -----------------------------------------------------------------------------
// Prikazuje sve knjige odabrane od korisnika i sve session id korisnika
// 
// The cart table has the structure
//
// CREATE TABLE cart
// (
//   session_id CHAR(32)  NOT NULL,
//   isbn       CHAR(15)  NOT NULL,
//   quantity   INT
// );
//
// and the books table has the structure
//
// CREATE TABLE books 
// (
//   isbn   CHAR(15)       PRIMARY KEY NOT NULL,
//   title  VARCHAR(100)   NOT NULL,
//   author VARCHAR(100)   NOT NULL,
//   pub    VARCHAR(20)    NOT NULL,
//   year   year           NOT NULL,
//   price  DECIMAL(9,2)   DEFAULT NULL
// );
//
// To display the customer's cart it is necessary to use the isbn to join
// these two tables
// -----------------------------------------------------------------------------

session_start();

$database = "bookstore";
$book_table = "books";
$cart_table = "cart";
$title = "Contents of Shopping Cart";

$db_link = db_connect($database);

if (isset($_REQUEST['remove'])) // remove button was clicked
{
   remove_book_from_cart($cart_table);
   $result = get_books_from_cart($cart_table, $book_table);
   display_cart_page($title, $result);
}
else // just display the contents of the cart
{
   $result = get_books_from_cart($cart_table, $book_table);
   display_cart_page($title, $result);
}

mysql_free_result($result);
mysql_close($db_link);

// ------------- database functions --------------------------------------------

function remove_book_from_cart($cart_table)
{
   $session_id = session_id();
   $isbn = $_REQUEST['isbn'];
   $query = "DELETE FROM $cart_table "
          . "WHERE session_id = '$session_id' AND isbn = '$isbn'";
   $result = mysql_query($query);
   return $result; // true if successful
}

function get_books_from_cart($cart_table, $book_table)
{
   $session_id = session_id();

   $query = "SELECT $cart_table.isbn AS isbn, quantity, title, author, pub, year, price "
          . "FROM $cart_table, $book_table "
          . "WHERE $cart_table.session_id = '$session_id' "
          . "AND $cart_table.isbn = $book_table.isbn";

   $result = mysql_query($query) or die("SQL Query Failed");
   return $result;
}

// ------------- HTML Code Generation ------------------------------------------

function display_cart_page($title, $result)
{
   if (mysql_num_rows($result) == 0)
   {
      display_empty_cart_page();
   }
   else
   {
?>
   <html>
   <head><title><?php echo $title?></title></head>
   <body>
   <h1><?php echo $title?></h1>
   <table border="1" width="100%">
   <?php display_column_headings($result);?>
   <?php display_table_rows($result);?>
   </table>
   <p>[ <a href="catalog.php?<?php echo SID?>">Return to catalog</a>
   | <a href="checkout.php?<?php echo SID?>">Checkout</a>
   ]</p>
   </body>
   </html>
<?php
   }
}
?>

<?php
function display_column_headings($result)
{
   // Get the number of columns in the table
   
   $num_columns = mysql_num_fields($result);

   // Use mysql_field_name to extract the column names
   // and display them as HTML table headings

   print "<tr>\n";
   for ($i = 0; $i < $num_columns; $i++)
   {
      print "<th>" . strtoupper(mysql_field_name($result, $i)) . "</th>\n";
   }

   // Display heading for remove buttons

   print "<th>REMOVE</th>\n";
   print "</tr>\n";
}
?>

<?php
function display_table_rows($result)
{
   $self = $_SERVER['PHP_SELF'] . "?" . SID;
   // Fetch the table rows one at a time and display the html table rows

   while ($row = mysql_fetch_assoc($result))
   {
      print "<tr>\n";
      foreach ($row as $col_value)
      {
         $col_value = htmlspecialchars(stripslashes($col_value));
         print "<td>$col_value</td>\n";
      }

      // print a form for each row with remove button
      // need a hidden field to record the isbn number.

      $isbn = htmlspecialchars($row['isbn']);
?>
      <form action="<?php echo $self?>" method="POST">
      <td><input type="hidden" name="isbn" value="<?php echo $isbn?>">
      <input type="submit" name="remove" value="remove"></td></form>
      </tr>
<?php
   }
}
?>

<?php
function display_empty_cart_page()
{
?>
   <html>
   <head><title>Empty Cart</title></head>
   <body>
   </body>
   <h1>Your cart is empty.</h1>
   <p>[ <a href="catalog.php?<?php echo SID?>">Return to catalog</a> ]</p>
   </html>
<?php
}
?>
