<?php
require_once("db_connect.php");

// ----------------------------------------------------------------------------------
// Prikazuje sve knjige u katalogu i dopusta korisniku da ih doda u listu za kupovinu 
// ----------------------------------------------------------------------------------

session_start();
$database = "bookstore";
$book_table = "books";
$cart_table = "cart";

// open a database connection

$db_link = db_connect($database);

// Get the books from the catalog as a result set

$result = get_books($book_table);

if (isset($_REQUEST['add'])) // add book button was clicked to cart
{
   add_book_to_cart($cart_table);
   display_catalog_page("Katalog Knjiga", $result);
}
else // just display catalog
{
   display_catalog_page("Katalog Knjiga", $result);
}

// close database connection

mysql_free_result($result);
mysql_close($db_link);


// --------------------- database funkcije ------------------------------------

 
// Dodaje novu knjigu u katalog ili azurira postojeci

function add_book_to_cart($cart_table)
{
   $row = find_book_in_cart($cart_table);
   
   if ($row) // entry already exists in cart
   {
      update_book_in_cart($cart_table, $row);
   }
   else // this is a new entry in cart
   {
      insert_book_in_cart($cart_table);
   }
}

// Vracanje svih knjiga u bazu podataka

function get_books($book_table)
{
   $query = "SELECT * FROM $book_table";
   $result = mysql_query($query) or die("SQL query failed");
   return $result;
}

// Pregled odabranih knjiga za ovog kupca 
// Vraca row (true) ako je knjiga naena else vraca false

function find_book_in_cart($cart_table)
{

   $isbn = $_REQUEST['isbn'];
   $session_id = session_id();

   $query = "SELECT * FROM $cart_table "
          . "WHERE session_id = '$session_id' and isbn = '$isbn'";
   $result = mysql_query($query) or die("SQL query failed");
   $row = mysql_fetch_assoc($result);
   mysql_free_result($result);
   return $row;
}

// Use insert if the book entry is not already in the cart

function insert_book_in_cart($cart_table)
{
   $session_id = session_id();
   $isbn = $_REQUEST['isbn'];
   $quantity = $_REQUEST['quantity'];

   $query = "INSERT INTO $cart_table VALUES ('$session_id', '$isbn', '$quantity')";
   $success = mysql_query($query);
   return $success;
}

// Use update if the book entry is already in the cart

function update_book_in_cart($cart_table, $row)
{
   $session_id = $row['session_id'];
   $isbn = $row['isbn'];
   $new_quantity = $row['quantity'] + $_REQUEST['quantity'];
   $query = "UPDATE $cart_table SET quantity = '$new_quantity' "
          . "WHERE session_id = '$session_id' AND isbn = '$isbn'";
   $success = mysql_query($query);
   return $success;
}

// --------------------- HTML code generation ----------------------------------

function display_catalog_page($title, $result)
{
?>
<html>
<head><title><?php echo $title?></title></head>
<body>
<h1><?php echo $title?></h1>
<table border="1" width="100%">
<?php display_column_headings($result);?>
<?php display_table_rows($result);?>
</table>
<p>[ <a href="cart.php?<?php echo SID?>">Prikaz Porudbine<a>
| <a href="checkout.php?<?php echo SID?>">Provjera</a>
]</p>
</body>
</html>
<?php
}

function display_column_headings($result)
{
   // Get the number of columns in the table
   
   $num_columns = mysql_num_fields($result);

   // Use mysql_field_name to extract the column names
   // and display them as HTML table headings

   print "<tr>\n";
   for ($i = 0; $i < $num_columns; $i++)
   {
      print "<th>" . strtoupper(mysql_field_name($result, $i)) . "</th>\n";
   }

   // Display heading for add buttons

   print "<th>CART</th>\n";
   print "</tr>\n";
}

function display_table_rows($result)
{
   $self = $_SERVER['PHP_SELF'] . "?" . SID;
   // Fetch the table rows one at a time and display the html table rows

   while ($row = mysql_fetch_assoc($result))
   {
      print "<tr>\n";
      foreach ($row as $col_value)
      {
         $col_value = htmlspecialchars(stripslashes($col_value));
         print "<td>$col_value</td>\n";
      }

      // print a form for each row with textfield and add button
      // need a hidden field to record the isbn number.

      $isbn = $row['isbn'];
?>

      <form action="<?php echo $self?>" method="POST">
      <td><input type="hidden" name="isbn" value="<?php echo $isbn?>">
      <input type="text" name="quantity" value="1" size="2">
      <input type="submit" name="add" value="add"></td></form>
      </tr>
<?php
   }
}
?>
