<?php
require_once("db_connect.php");
// -----------------------------------------------------------------------------
// Checkout.
// The cart table has the structure
//
// CREATE TABLE cart
// (
//   session_id CHAR(32)  NOT NULL,
//   isbn       CHAR(15)  NOT NULL,
//   quantity   INT
// );
//
// It is necessary to generate a customer id for the customer and transfer
// the customer's items from the cart to the books_ordered database table
// which has the structure
//
// CREATE TABLE books_ordered
// (
//    customer_id CHAR(32) NOT NULL,
//    isbn        CHAR(15) NOT NULL,
//    quantity    INT
// );
//
// It is also necessary to make an entry for the customer in the customers
// database table which has the structure
//
// CREATE TABLE customers
// (
//    customer_id   CHAR(32) PRIMARY KEY,
//    first_name    VARCHAR(50) NOT NULL,
//    last_name     VARCHAR(50) NOT NULL
// );
//
// In a more compete application several fields beside the name (e.g., address
// and credit card info) would also be needed).
//
// -----------------------------------------------------------------------------

session_start();

$database = "bookstore";
$book_table = "books";
$cart_table = "cart";
$order_table = "books_ordered";
$customer_table = "customers";

$title = "Contents of Shopping Cart";

$db_link = db_connect($database);

$result = get_books_from_cart($cart_table);

if (mysql_num_rows($result) == 0)
{
  display_empty_cart_page();
}
elseif (isset($_REQUEST['submit'])) // customer data has been submitted
{
   $error_message = validate_form();
   if(! $error_message)
   {
      make_customer_order($result, $order_table, $customer_table);
      remove_books_from_cart($cart_table);
      display_order_complete_page();
   }
   else
   {
      display_customer_data_page($error_message);
   }
}
else
{
   display_customer_data_page("");
}

mysql_free_result($result);
mysql_close($db_link);

// ------------- database functions --------------------------------------------

function get_books_from_cart($cart_table)
{
   $session_id = session_id();
   $query = "SELECT isbn, quantity FROM $cart_table "
          . "WHERE session_id = '$session_id'";
   $result = mysql_query($query) or die("SQL Query Failed");
   return $result;
}

function make_customer_order($cart_result, $order_table, $customer_table)
{
   $customer_id = uniqid("ORDER_");
   while ($row = mysql_fetch_array($cart_result))
   {
      list($isbn, $quantity) = $row;
      $query = "INSERT INTO $order_table " 
             . "VALUES ('$customer_id', '$isbn', '$quantity')";
      $result = mysql_query($query) or die("SQL Query Failed");
   }

   $first_name = addslashes($_REQUEST['first_name']);
   $last_name = addslashes($_REQUEST['last_name']);

   $query = "INSERT INTO $customer_table "
          . "VALUES ('$customer_id', '$first_name', '$last_name')";
   $result = mysql_query($query) or die("SQL Query Failed");
}

function remove_books_from_cart($cart_table)
{
   $session_id = session_id();
   $query = "DELETE FROM $cart_table WHERE session_id = '$session_id'";
   $result = mysql_query($query);
}

function validate_form()
{
   $err = "";
   if ($_REQUEST['first_name'] == "")
   {
      $err .= "<b>ERROR:</b> You must enter a first name<br>";
   }
   if ($_REQUEST['last_name'] == "")
   {
      $err .= "<b>ERROR:</b> You must enter a last name<br>";
   }
   return $err;
}

// ------------- HTML Code Generation ------------------------------------------

function display_empty_cart_page()
{
?>
   <html>
   <head><title>Empty Cart</title></head>
   <body>
   </body>
   <h1>Your cart is empty.</h1>
   <p>[ <a href="catalog.php">Return to catalog</a> ]</p>
   </html>
<?php
}
?>

<?php
function display_customer_data_page($error_message)
{
   $self = $_SERVER['PHP_SELF'] . "?" . SID;
   $first_name = isset($_REQUEST['first_name']) ? $_REQUEST['first_name'] : "";
   $last_name = isset($_REQUEST['last_name']) ? $_REQUEST['last_name'] : "";
?>
   <html>
   <head><title>Customer Data Entry</title></head>
   <body>
   <h1>Customer Data</h1>
   <?php print $error_message?>
   <form action="<?php echo $self?>" method="POST">

   <table border="1">
   <tr><td>

   <table>
   <tr>
      <td>First name:</td> 
      <td><input type="text" name="first_name" value="<?php echo $first_name;?>"></td>
   </tr>
   <tr>
      <td>Last name:</td>
      <td><input type="text" name="last_name" value="<?php echo $last_name;?>"></td>
   </tr>
   <tr>
      <td colspan="2"><input type="submit" name="submit" value="submit"></td>
   </tr>
   </form>
   </table>

   </td></tr>
   </table>

   <p>
   [ <a href="catalog.php?<?php echo SID?>">Return to catalog</a>
   | <a href="cart.php?<?php echo SID?>">Return to cart</a>
   ]
   </p>

<?php
}
?>

<?php
function display_order_complete_page()
{
?>
   <html>
   <head><title>Order Complete</title></head>
   <body>
   <h1>Thank you for your order</h1>
   <p>[ <a href="catalog.php?<?php echo SID?>">Return to catalog</a> ]</p>
<?php
}
?>
