import random
import math


def hill_climbing(problem):
    
    curr_state = problem.start
    
    while True:
        
        best_succ = None
        best_score = -1
        
        actions = problem.get_actions(curr_state)
        for action in actions:
            next_state = problem.get_successor(curr_state, action)
            next_score = problem.get_score(next_state)
            if best_score < next_score:
                best_score = next_score
                best_succ = next_state
        
        curr_score = problem.get_score(curr_state)
        print(curr_score, best_score)
        if best_score > curr_score:
            curr_state = best_succ
        else:
            break
    
    return curr_state


def temp_schedule(t, a=30, b=0.005, limit=1e-6):
    T = a * math.exp(-b*t)
    if T < limit:
        T = 0.0
    return T

def simulated_annealing(problem):
    
    curr_state = problem.start
    
    t = 0
    
    while True:
        
        actions = problem.get_actions(curr_state)
        successors = [problem.get_successor(curr_state, action) for action in actions]
        next_state = random.choice(successors)
        
        delta = problem.get_score(next_state) - problem.get_score(curr_state)
        if delta > 0:
            curr_state = next_state
        else:
            T = temp_schedule(t)
            if T == 0.0:
                break
            p = math.exp(delta / T)
            if random.uniform(0.0, 1.0) <= p:
                curr_state = next_state
        
        t += 1
    
    return curr_state