import random

class NQueens:
    
    def __init__(self, n):
        self.n = n
        self.start = [random.randint(0, n-1) for col in range(n)]
    
    def get_actions(self, state):
        actions = []
        for col, row in enumerate(state):
            new_rows = set(range(self.n)) - {row}
            actions += [(col, new_row) for new_row in new_rows]
        return actions
    
    def get_successor(self, state, action):
        col, new_row = action
        new_state = [row for row in state]
        new_state[col] = new_row
        return new_state

    def print_state(self, state):
        mat = [['.' for j in range(self.n)] for i in range(self.n)]
        for col, row in enumerate(state):
            mat[row][col] = 'Q'
        print(*mat, sep='\n')
        print()
    
    def get_score(self, state):
        cnt = 0
        for col1, row1 in enumerate(state[:-1]):
            for col2, row2 in enumerate(state[col1+1:], start=col1+1):
                if col1 != col2 and row1 != row2 and abs(row1 - row2) != abs(col1 - col2):
                    cnt += 1
        return cnt